/** Contains examples of loops used in this livetext, 
 each in its own static method.
 1. exp (for exponentiation)
 */
public class Loops {
    
    /** = b^c, given c >= 0 */
    public static int exp(int b, int c) {
        int x= b;
        int y= c;
        int z= 1;
        // {invariant: z*x^y = b^c  and  0 <= y <= c}
        while (y != 0) {
            if (y % 2 == 0) 
            { x= x*x;  y= y/2; }
            else
            { z= z*x; y= y-1; }
        }
        return z;
    }
    
    /** = number of weeks it takes to fill an apartment
     of volume aptVol */
    public static int roach(int aptVol) {
        // Calculate the number w of weeks it takes
        // a roach infestation to completely fill an apartment
        int w= 0;
        int pop= 100; // roach population after w weeks
        while (aptVol > pop*.001) {
            w= w+1;
            pop= pop + (5*pop)/4;
        }
        return w;
    }
    
    
    /** = "integer p is a prime" */
    public static boolean isPrime(int p) {
        // Set b= "p is a prime"
        boolean b=  p > 1;
        int k= 2;
        // {inv: b  == p > 1 && 
        //       no integer in 2..(k-1) divides p}
        while (b && k != p) {
            if (p % k == 0)  b= false;
            k= k+1;
        }
        // {b  == p >1 && no integer in 2..(p-1) divides p}
        return b;
        
        // Note: This algorithm can be made much faster by using the
        // fact that if q divides p, then at least one of q and p/q
        // is at most sqrt(p).
    }
    
    /** = the # of w's in s[0..s.length()-1] */
    public static int numberW(String s) {
        // Set x to the # of w's in s[0..s.length()-1]
        int x= 0;
        int k= 0;
        // {invariant: x = # of w's in s[0..k-1]}
        while (k != s.length()) {
            if (s.charAt(k) == 'w') x= x+1;
            k= k+1;
        }
        // x = # of w's in s[0..s.length()-1]
        return x;
    }
    
    /** = the reverse of t */
    public static String reverse(String t) {
        StringBuffer s= new StringBuffer(t);
        int k= 0;
        int n= s.length()-1;
        // {invariant: s[0..k-1] is already reversed,
        //             s[n+1..] is already reversed,
        //             s[k..n] is still to be reversed}
        while (k < n) {
            char c= s.charAt(k);
            s.setCharAt(k, s.charAt(n));
            s.setCharAt(n, c);
            k= k+1; n= n-1;
        }
        t= s.toString();
        return t;
    }
    
    /** = the number of primes in 2..(n-1) */
    public static int numberPrimes(int n) {
        // Set x to the # of primes in 2..(n-1)
        int x= 0;
        // {inv: x = # primes in 2..i-1
        for (int i= 2; i != n; i= i+1) {
            // Set fresh variable b to "i is prime"
            boolean b=  i > 1; 
            int k= 2;
            // {inv: b == i > 1 &&
            //       no integer in 2..(k-1) divides i}
            while (b  &&  k != i) {
                if (i % k == 0)  b= false;
                k= k+1;
            }
            
            if (b) {x= x+1;}
        }
        return x;
    }
}
